<?php

	/**
	 * Plugin Name:			Manufacturer Tables Shortcode
	 * Plugin URI:			https://themeforest.net/user/stylemixthemes
	 * Description:			Tables for WooCommerce
	 * Version:				1.2
	 * Author:				StylemixThemes
	 * Author URI:			https://themeforest.net/user/stylemixthemes
	 * License:				GPL-2.0+
	 * License URI:			http://www.gnu.org/licenses/gpl-2.0.txt
	 */

	#-----------------------------------------------------------------#
	# Create Portfolio 
	#-----------------------------------------------------------------# 

	// Table List

function woo_products_table_shortcode( $atts, $content = null ) {
?>



<table class="man_table">

<?php


extract(shortcode_atts(array(
		"categories" => ''
	), $atts));


global $post;
$terms = get_the_terms( $post->ID, 'product_cat' );
$nterms = get_the_terms( $post->ID, 'product_tag'  );

if (!empty($terms)) {
	foreach ($terms as $term  ) {
	    $product_cat_id = $term->term_id;
	    $product_cat_slug = $term->slug;
	    break;
	}
}


if ($categories == 'this') {
	$categories = $product_cat_slug;
}





$args = array(
'tax_query' => array(
'relation' => 'AND',
array(
'taxonomy' => 'product_cat',
'field' => 'slug',
'terms' => $categories, //category
),
),
'posts_per_page' => 4, // number of items
'post_type' => 'product', // page type
'orderby' => 'title', // sort
);
 
$loop = new WP_Query( $args );
while ( $loop->have_posts() ) : $loop->the_post();
global $product;
?>

<tr>
	
	<td class="man_table_img">
		<a href="<?php echo get_permalink( $loop->post->ID ) ?>">
			<?php woocommerce_show_product_sale_flash( $post, $product ); ?>
			<?php
			if (has_post_thumbnail( $loop->post->ID )) echo get_the_post_thumbnail($loop->post->ID, 'shop_thumbnail');
			else echo '<img src="'.wc_placeholder_img_src().'" alt="<?php the_title(); ?>"/>';
			?>
			</a>
	</td>

	<td class="man_table_name">
		<a href="<?php echo get_permalink( $loop->post->ID ) ?>"><b><?php the_title(); ?></b></a>
	</td>


	<?php foreach ( $product->get_attributes() as $attribute ) : ?>

			<td><?php
				$values = array();

				if ( $attribute->is_taxonomy() ) {
					$attribute_taxonomy = $attribute->get_taxonomy_object();
					$attribute_values = wc_get_product_terms( $product->get_id(), $attribute->get_name(), array( 'fields' => 'all' ) );

					foreach ( $attribute_values as $attribute_value ) {
						$value_name = esc_html( $attribute_value->name );

						if ( $attribute_taxonomy->attribute_public ) {
							$values[] = '<a href="' . esc_url( get_term_link( $attribute_value->term_id, $attribute->get_name() ) ) . '" rel="tag">' . $value_name . '</a>';
						} else {
							$values[] = $value_name;
						}
					}
				} else {
					$values = $attribute->get_options();

					foreach ( $values as &$value ) {
						$value = make_clickable( esc_html( $value ) );
					}
				}

				echo apply_filters( 'woocommerce_attribute', wpautop( wptexturize( implode( ', ', $values ) ) ), $attribute, $values );
			?></td>
	<?php endforeach; ?>

</tr>


<?php endwhile;?>

<?php wp_reset_query(); ?>
</table> <?php
 
}
 
add_shortcode("woo_products_table", "woo_products_table_shortcode");

?>