<div class="wrap about-wrap full-width-layout qlwrap">
  <form method="post" action="options.php">
    <?php settings_fields(sanitize_key(QUADMENU_DOMAIN . '_license' . '-group')); ?>
    <?php do_settings_sections(sanitize_key(QUADMENU_DOMAIN . '_license' . '-group')); ?>
    <table class="widefat quadmenu-system-table">
      <thead>
        <tr>
          <th colspan="3"><?php esc_html_e('License', 'quadmenu'); ?></th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td class="quadmenu-system-name"><?php esc_html_e('Market', 'quadmenu'); ?></td>
          <td class="quadmenu-system-status">
            <div class="quadmenu-system-led info" title="<?php esc_html_e('Enter the market where you\'ve purchased the license.', 'quadmenu'); ?>">i</div>              
          </td>
          <td class="quadmenu-system-name">
            <select style="width:350px" name="<?php echo esc_attr(QUADMENU_DOMAIN . '_license'); ?>[market]">
              <option <?php selected($quadmenu_license->market, ''); ?> value="">QuadLayers</option>
              <option <?php selected($quadmenu_license->market, 'envato'); ?> value="envato">Envato</option>
              <option <?php selected($quadmenu_license->market, 'emp'); ?> value="emp">Elegant Market Place</option>
            </select>
          </td>
        </tr>
        <tr>
          <td class="quadmenu-system-name"><?php esc_html_e('Key', 'quadmenu'); ?></td>
          <td class="quadmenu-system-status">
            <div class="quadmenu-system-led info" title="<?php esc_html_e('Enter your license key.', 'quadmenu'); ?>">i</div>              
          </td>
          <td class="quadmenu-system-name">
            <input style="width:350px" type="password" name="<?php echo esc_attr(QUADMENU_DOMAIN . '_license' . '[license_key]'); ?>" placeholder="<?php esc_html_e('Enter your license key.', 'quadmenu'); ?>" value="<?php echo esc_attr($quadmenu_license->license_key); ?>" class="quadmenu-input"/>
          </td>
        </tr>
        <tr>
          <td class="quadmenu-system-name"><?php esc_html_e('Email', 'quadmenu'); ?></td>
          <td class="quadmenu-system-status">
            <div class="quadmenu-system-led info" title="<?php esc_html_e('Enter your license email.', 'quadmenu'); ?>">i</div>              
          </td>
          <td class="quadmenu-system-name">
            <input style="width:350px" type="password" name="<?php echo esc_attr(QUADMENU_DOMAIN . '_license' . '[email]'); ?>" placeholder="<?php esc_html_e('Enter your order email.', 'quadmenu'); ?>" value="<?php echo esc_attr($quadmenu_license->email); ?>" class="quadmenu-input"/>
          </td>
        </tr>
      </tbody>
    </table>
    <?php submit_button() ?>
  </form>
  <table class="widefat quadmenu-system-table" cellspacing="0">
    <thead>
      <tr>
        <th colspan="2"><?php esc_html_e('Status', 'quadmenu'); ?></th>
      </tr>
    </thead>
    <tbody>
      <?php if ($activation = $quadmenu_updater->get_activation()) : ?>
        <?php if (isset($activation->license_created)) : ?>
          <tr>
            <td class="quadmenu-system-name"><?php _e('Created', 'quadmenu') ?></td>
            <td class="quadmenu-system-value"><?php echo date(get_option('date_format'), strtotime($activation->license_created)) ?></td>
          </tr>
        <?php endif; ?>
        <?php if (isset($activation->activation_instance)) : ?>
          <tr>
            <td class="quadmenu-system-name"><?php _e('Instance', 'quadmenu') ?></td>
            <td class="quadmenu-system-value"><?php echo esc_attr($activation->activation_instance); ?></td>
          </tr>
        <?php endif; ?>
        <?php if (isset($activation->license_limit)) : ?>
          <tr>
            <td class="quadmenu-system-name"><?php _e('Limit', 'quadmenu') ?></td>
            <td class="quadmenu-system-value"><?php echo $activation->license_limit ? esc_attr($activation->license_limit) : esc_html__('Unlimited', 'quadmenu'); ?></td>
          </tr>
        <?php endif; ?>
        <?php if (isset($activation->activation_count)) : ?>
          <tr>
            <td class="quadmenu-system-name"><?php _e('Activations', 'quadmenu') ?></td>
            <td class="quadmenu-system-value"><?php echo esc_attr($activation->activation_count); ?></td>
          </tr>
        <?php endif; ?>
        <?php if (isset($activation->license_updates)) : ?>
          <tr>
            <td class="quadmenu-system-name"><?php _e('Updates', 'quadmenu') ?></td>
            <td class="quadmenu-system-value"><?php echo ($activation->license_expiration != '0000-00-00 00:00:00' && $activation->license_updates) ? sprintf(__('Expires on %s', 'quadmenu'), date_i18n(get_option('date_format'), strtotime($activation->license_expiration))) : esc_html__('Unlimited', 'quadmenu'); ?></td>
          </tr>
        <?php endif; ?>
        <?php if (isset($activation->license_support)) : ?>
          <tr>
            <td class="quadmenu-system-name"><?php _e('Support', 'quadmenu') ?></td>
            <td class="quadmenu-system-value"><?php echo ($activation->license_expiration != '0000-00-00 00:00:00' && $activation->license_support) ? sprintf(__('Expires on %s', 'quadmenu'), date_i18n(get_option('date_format'), strtotime($activation->license_expiration))) : esc_html__('Unlimited', 'quadmenu'); ?></td>
          </tr>
        <?php endif; ?>
        <!--<?php if (isset($activation->license_expiration)) : ?>
              <tr>
                <td class="quadmenu-system-name"><?php _e('Expiration', 'quadmenu') ?></td>
                <td class="quadmenu-system-value"><?php echo ($activation->license_expiration != '0000-00-00 00:00:00') ? date_i18n(get_option('date_format'), strtotime($activation->license_expiration)) : __('Unlimited', 'quadmenu'); ?></td>
              </tr>
        <?php endif; ?>-->
        <tr>
          <td class="quadmenu-system-name"><?php esc_html_e('Status', 'quadmenu'); ?></td>
          <td class="quadmenu-system-value"><?php echo esc_html($activation->message); ?></td>
        </tr>
      <?php endif; ?>
      <tr>
        <td class="quadmenu-system-name"><?php esc_html_e('Message', 'quadmenu'); ?></td>
        <td class="quadmenu-system-value">
          <?php if (empty($activation->activation_instance)): ?>
            <?php printf(__('Before you can receive plugin updates, you must first authenticate your license. To locate your License Key, <a href="%s" target="_blank">log in</a> to your account and navigate to the <strong>Account > Licenses</strong> page.', 'quadmenu'), QUADMENU_PRO_LICENSES_URL); ?>
          <?php else: ?>
            <?php printf(__('Thanks for register your license! If you have doubts you can request <a href="%s" target="_blank">support</a> through our ticket system.', 'quadmenu'), QUADMENU_PRO_SUPPORT_URL); ?>
          <?php endif; ?>
        </td>
      </tr>
    </tbody>
  </table>
</div>