<?php
/*
 * Plugin Name: QuadMenu PRO
 * Plugin URI:  https://www.quadmenu.com
 * Description: The best drag & drop WordPress Mega Menu plugin which allow you to create Tabs Menus & Carousel Menus.
 * Version:     1.8.9
 * Author:      Mega Menu
 * Author URI:  https://www.quadmenu.com
 * Copyright:   2018 QuadMenu (https://www.quadmenu.com)
 * Text Domain: quadmenu-pro
 */

if (!defined('ABSPATH'))
  exit;

define('QUADMENU_PRO_DB_KEY', '_menu_item_quadmenu');
define('QUADMENU_PRO_PLUGIN_NAME', 'QuadMenu PRO');
define('QUADMENU_PRO_PLUGIN_VERSION', '1.8.9');
define('QUADMENU_PRO_PLUGIN_FILE', __FILE__);
define('QUADMENU_PRO_PLUGIN_DIR', __DIR__ . DIRECTORY_SEPARATOR);
define('QUADMENU_PRO_DEMO_URL', 'https://quadmenu.com/?utm_source=quadmenu_admin');
define('QUADMENU_PRO_LICENSES_URL', 'https://quadmenu.com/account/licenses/?utm_source=quadmenu_admin');
define('QUADMENU_PRO_SUPPORT_URL', 'https://quadmenu.com/account/support/?utm_source=quadmenu_admin');

final class QuadMenu_PRO {

  protected static $instance;
  var $free = 'quadmenu';

  function add_body_class($classes) {

    $screen = get_current_screen();

    $classes .= ' quadmenu-pro';

    return $classes;
  }

  function add_customizer($ReduxFramework) {

    if (is_admin() || is_customize_preview()) {

      require_once 'includes/customizer/customizer.php';

      new QuadMenu_Customizer($ReduxFramework);
    }
  }

  function save_menu_meta_box($post_id) {

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
      return $post_id;

    if (current_user_can('manage_options')) {
      if (array_key_exists('quadmenu', $_POST)) {
        if ($quadmenu = array_filter($_POST['quadmenu'])) {
          update_post_meta($post_id, QUADMENU_PRO_DB_KEY, $quadmenu);
        } else {
          delete_post_meta($post_id, QUADMENU_PRO_DB_KEY);
        }
      }
    }
  }

  function menu_meta_box($post) {

    $quadmenu = wp_parse_args(get_post_meta($post->ID, QUADMENU_PRO_DB_KEY, true), array(
        'menu' => '',
        'layout' => '',
        'theme' => ''
    ));

    $widget = new QuadMenu_Widget();
    ?>
    <p>
      <label for="quadmenu_menu"><?php esc_html_e('Menu', 'quadmenu'); ?></label>
      <select id="quadmenu_menu" name="quadmenu[menu]" class="widefat">
        <option value=""><?php esc_html_e('Default', 'quadmenu'); ?></option>
        <?php echo $widget->menus($quadmenu['menu']); ?>
      </select>
    </p>
    <p>
      <label for="quadmenu_theme"><?php esc_html_e('Theme', 'quadmenu'); ?></label>
      <select id="quadmenu_theme" name="quadmenu[theme]" class="widefat">
        <option value=""><?php esc_html_e('Default', 'quadmenu'); ?></option>
        <?php echo $widget->themes($quadmenu['theme']); ?>
      </select>
    </p>
    <p>
      <label for="quadmenu_layout"><?php esc_html_e('Layout', 'quadmenu'); ?></label>
      <select id="quadmenu_layout" name="quadmenu[layout]" class="widefat">
        <option value=""><?php esc_html_e('Default', 'quadmenu'); ?></option>
        <?php echo $widget->layouts($quadmenu['layout']); ?>
      </select>
    </p>
    <?php
    wp_nonce_field(QUADMENU_DOMAIN, 'nonce');
  }

  function add_menu_meta_box() {
    if (current_user_can('manage_options')) {
      add_meta_box(QUADMENU_DOMAIN, esc_html(QUADMENU_PRO_PLUGIN_NAME), array($this, 'menu_meta_box'), '', 'side', 'high');
    }
  }

  function add_meta_box_parameters($args) {

    // 1326
    // agregar quadmenu theme location al metabox
    if (!empty($args['theme_location'])) {

      if (function_exists('is_shop') && is_shop()) {
        if ($quadmenu = get_post_meta(wc_get_page_id('shop'), QUADMENU_PRO_DB_KEY, true)) {
          $args = wp_parse_args($quadmenu, $args);
        }
      } elseif (!is_archive()) {
        if ($quadmenu = get_post_meta(get_queried_object_id(), QUADMENU_PRO_DB_KEY, true)) {
          $args = wp_parse_args($quadmenu, $args);
        }
      }
    }

    return $args;
  }

  function includes() {
    require_once 'includes/notices.php';
    if (class_exists('QuadMenu')) {
      require_once 'includes/panel/license.php';
      require_once 'includes/advanced.php';
      require_once 'includes/woocommerce.php';
      require_once 'includes/divi/divi.php';
    }
  }

  function init() {

    add_action('admin_init', array($this, 'add_updater'));

    if (class_exists('QuadMenu')) {
      add_filter('admin_body_class', array($this, 'add_body_class'), 99);
      add_action('add_meta_boxes', array($this, 'add_menu_meta_box'));
      add_action('save_post', array($this, 'save_menu_meta_box'));
      add_filter('quadmenu_get_nav_menu_args', array($this, 'add_meta_box_parameters'), 15);
      if (defined('QUADMENU_DB_OPTIONS')) {
        add_action('redux/extensions/' . QUADMENU_DB_OPTIONS . '/before', array($this, 'add_customizer'), 0);
      }
    }
  }

  function add_updater() {

    global $quadmenu_updater;

    include_once(QUADMENU_PRO_PLUGIN_DIR . 'lib/QLWDDUpdater.php');

    $quadmenu_updater = qlwdd_updater(array(
        'api_url' => 'https://quadmenu.com/wc-api/qlwdd/',
        'plugin_url' => QUADMENU_PRO_DEMO_URL,
        'plugin_file' => QUADMENU_PRO_PLUGIN_FILE,
        'license_url' => admin_url('admin.php?page=quadmenu_license'),
        'product_key' => '81b0d2dc2806687a11ded4c0e9cea254',
        'envato_key' => 'Gn46hMOIcvz8uyVvpe0jB2ge7A1RdH5T',
        'envato_id' => '21315450',
        'emp_id' => '567872'
    ));
  }

  public static function instance() {
    if (!isset(self::$instance)) {
      self::$instance = new self();
      self::$instance->init();
      self::$instance->includes();
    }
    return self::$instance;
  }

}

add_action('plugins_loaded', array('QuadMenu_PRO', 'instance'));
